package gui.attivita.atomiche;

import gui.*;
import _framework.Task;
import lega.*;
import gui.InformazioniPartita;

import java.util.*;
import _framework.*;


public class EstraiInformazioniPartite implements Task{
	HashSet<InformazioniPartita> risultato = new HashSet<InformazioniPartita>();
	boolean eseguita = false;
	Set<TipoLinkPartita> partite;
	
	public EstraiInformazioniPartite(Set<TipoLinkPartita> partite){
		this.partite = partite;
	}
	
	public synchronized void esegui(Executor e){
		if (e == null || eseguita)
			return;
		eseguita = true;
		// legge i dati delle partite, li memorizza in oggetti InformazioniPartita, e li inserisce nel risultato		 
		Iterator<TipoLinkPartita> it = partite.iterator();
		while(it.hasNext()){
			risultato.add(new InformazioniPartita(it.next()));
		}	
	}
	
	public synchronized boolean estEseguita(){
		return eseguita;
	}
	
	public synchronized Set<InformazioniPartita> getRisultato(){
		if(!eseguita)
			throw new RuntimeException("Risultato non disponibile!");
		return risultato;
	}	
}



