package gui;

import lega.TipoLinkPartita;

public class InformazioniPartita{
	// Contiene le informazioni associate ad una partita, di rilievo per l'interfaccia
	
	private final String nomeSquadraCasa;
	private final int goalCasa;
	private final String nomeSquadraTrasferta;
	private final int goalTrasferta;
	private final TipoLinkPartita linkPartita;
	
	public InformazioniPartita(TipoLinkPartita linkPartita){
		this.linkPartita = linkPartita; // link partita d'origine (accessibile solo tramite Task!)
		nomeSquadraCasa = linkPartita.getCasa().getNome();
		nomeSquadraTrasferta = linkPartita.getTrasferta().getNome();
		goalCasa = linkPartita.getGoalCasa();
		goalTrasferta = linkPartita.getGoalTrasferta();
	}
	
	public String getNomeSquadraCasa(){
		return nomeSquadraCasa;
	}
	
	public String getNomeSquadraTrasferta(){
		return nomeSquadraTrasferta;
	}
	
	public int getGoalCasa(){
		return goalCasa;
	}
	
	public int getGoalTrasferta(){
		return goalTrasferta;
	}
	
	public TipoLinkPartita getTipoLinkPartita(){
		return linkPartita;
	}
	
	public String toString(){
		return nomeSquadraCasa + "-" + nomeSquadraTrasferta + " : " + goalCasa + " -" + goalTrasferta;
	}

}
