package gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import lega.*;

public final class FinestraLeggiPartita extends JFrame implements ActionListener{
	private final String titolo = "Partite";
	
	private Hashtable<JButton,TipoLinkPartita> tabella = new Hashtable<JButton,TipoLinkPartita>();
	
	private boolean fatto = false;
	private TipoLinkPartita partitaSelezionata;
	
	public FinestraLeggiPartita(Set<InformazioniPartita> infoPartite){
		super();
		setTitle(titolo);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setLayout(new FlowLayout());
		
		
		
		
		Iterator<InformazioniPartita> it = infoPartite.iterator();
		while (it.hasNext()){
			InformazioniPartita infoPartita = it.next();
			JButton b = new JButton(infoPartita.toString());
			b.addActionListener(this);// Associa la classe corrente come ActionListener del pulsante
			getContentPane().add(b);
			tabella.put(b, infoPartita.getTipoLinkPartita());
		}
		//Bottone per uscire dal ciclo
		JButton b = new JButton("Nessuna partita");
		b.addActionListener(this);// Associa la classe corrente come ActionListener del pulsante
		getContentPane().add(b);
		pack();
		setVisible(true);
	}
	
	public TipoLinkPartita attendiSelezione(){
		synchronized (this){
			while(!fatto){
				try{
					this.wait();
				}
				catch (InterruptedException e){
					e.printStackTrace();
				}
				// Nasconde il JFrame prima di restituire la selezione dell'utente
				setVisible(false);
				return partitaSelezionata;
			}
		}
		return null; // non e' mai eseguita
	}
	
	// Realizzazione dell'ActionListener
	public void actionPerformed(ActionEvent actionEvent){// Implementa il listener della finestra
		synchronized(this){
			fatto = true;
			partitaSelezionata = tabella.get(actionEvent.getSource());
			this.notify();
		}
	}	
}



