package esercizio1bang;

public class Corridore implements Runnable{
	
	private final String nome;
	private final static int METRI=100;
	private ContatoreSincronizzato pronti;
	private final Bang bang;
	
	public Corridore(String nome, ContatoreSincronizzato pronti, Bang bang){
		this.nome = nome;
		this.bang = bang;
		this.pronti = pronti;
	}
	
	public void run(){
		int spazio=0;
		try
		{					
			while(spazio<METRI){
				
				if(spazio == 0){// E' la prima iterazione					
						System.out.println(nome+" pronto a partire");
						pronti.incrementa();
						bang.attendiBang();
				}
				
				spazio++;
				Thread.sleep(1);
				System.out.println(nome+" "+spazio+" metri");
			}
			System.out.println("Il corridore " + nome + " e' arrivato");
		}
		catch(InterruptedException err){
			err.printStackTrace();
		}
		
	}


	public String getNome() {
		return nome;
	}
	
}
