package esercizio1bang;

public class ContatoreSincronizzato {
	private final int max;
	private int valoreCorrente = 0;
	
	public ContatoreSincronizzato(int max){
		this.max = max;
	}
	
	public synchronized void incrementa(){
		if (valoreCorrente < max){
			valoreCorrente++;
		}
		notifyAll();
	}
	
	public synchronized void attendiCompletamento(){
		while(valoreCorrente < max){
			// Aspetta che il valore corrente raggiunga il massimo
			try{
				wait();
			}
			catch(InterruptedException e){
				e.printStackTrace();
			}
		}		
	}
}
