package gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.util.Comparator;
import java.util.Set;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

import ciclisti.ciclista.Ciclista;
import ciclisti.partecipa.TipoLinkPartecipa;

public class ProclamaVincitoriFrame extends JFrame 
{
	private JList listaVincitori;
	private JTable tabellaCiclisti;
	private JPanel westPanel=new JPanel();
	private JTabbedPane tabPnl=new JTabbedPane();
	
	public ProclamaVincitoriFrame(Set<Ciclista> vincitori, Set<TipoLinkPartecipa> linkPartecipanti)
	{
		super("Riassunto della gara e vincitori");
		listaVincitori=popolaListaVincitori(vincitori);
		tabellaCiclisti=popolaTabellaClassifica(linkPartecipanti);
		getContentPane().add(tabPnl,BorderLayout.CENTER);
		tabPnl.add("Tabella dei ciclisti",new JScrollPane(tabellaCiclisti));
		tabPnl.add("Lista dei vincitori",new JScrollPane(listaVincitori));
		setSize(600,600);
		
		Dimension dim =Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((int)((dim.getWidth()-this.getWidth())/2),
			(int)((dim.getHeight()-this.getHeight())/2));
		setVisible(true);
	}
	
	private JTable popolaTabellaClassifica(Set<TipoLinkPartecipa> linkPartecipanti)
	{
		String[][] tabella=new String[linkPartecipanti.size()][2];
		int riga=0;
		for(TipoLinkPartecipa l : linkPartecipanti)
		{
			tabella[riga][0]=l.getCiclista().getNome();
			tabella[riga++][1]=l.getKmPercorsi()+"";
		}
		String[] intestazioni={"Nome Ciclista","Km percorsi"};
		return new JTable(tabella,intestazioni);
	}
	
	private JList popolaListaVincitori(Set<Ciclista> vincitori)
	{
		Vector<String> nomeVincitori=new Vector<String>();
		for (Ciclista vincitore : vincitori)
		{
			nomeVincitori.add(vincitore.getNome());
		}
		return new JList(nomeVincitori);		
	}
	
	
}
