package gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class InserisciDatiGara extends JFrame
{
	class Ascoltatore implements ActionListener
	{
		public void actionPerformed(ActionEvent arg0) 
		{
			synchronized(getContentPane())
			{
				getContentPane().notify();
				dispose();
			}		
		}		
	}
	
	private JLabel nomeLbl=new JLabel("Nome:");
	private JTextField nomeTxt=new JTextField();
	private JLabel distanzaLbl=new JLabel("Distanza:");
	private JTextField distanzaTxt=new JTextField();
	private JPanel centroPnl=new JPanel();
	private JPanel sudPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	
	public InserisciDatiGara()
	{
		super("Inserimento Dati Gara");
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		centroPnl.setLayout(new GridLayout(2,2));
		centroPnl.add(nomeLbl);
		centroPnl.add(nomeTxt);
		centroPnl.add(distanzaLbl);
		centroPnl.add(distanzaTxt);
		sudPnl.add(okBtn);
		okBtn.addActionListener(new Ascoltatore());
		setSize(300,150);
		setVisible(true);
		Dimension dim =Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((int)((dim.getWidth()-this.getWidth())/2),
			(int)((dim.getHeight()-this.getHeight())/2));

	}
	
	public String leggiNome()
	{
		return nomeTxt.getText();
	}
	
	public String leggiDistanza()
	{
		return distanzaTxt.getText();
	}
	
	public void aspettaOK()
	{
		synchronized(getContentPane())
		{
			try {
				getContentPane().wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		}
	}
}
