package ciclisti.ciclista;

import java.util.*;

import _framework.*;
import _gestioneeventi.*;

import eventi.*;
import ciclisti.*;
import ciclisti.partecipa.*;
import ciclisti.ciclista.Ciclista.Stato;

public class CiclistaFired implements Task{
	private boolean eseguita = false;
	private Ciclista ciclista;
	private Evento evento;

	public CiclistaFired(Ciclista ciclista, Evento evento) {
		this.ciclista = ciclista;
		this.evento = evento;
	}
	
	public synchronized void esegui(Executor executor){
		if (eseguita || executor == null
				|| (evento.getDestinatario() != ciclista && evento.getDestinatario() != null)
				|| ciclista.getLinkPartecipa() == null // Verifica precondizione
			){
			return;
		}
		eseguita = true;
				
		switch (ciclista.getStato()) {
			case PRONTO:
				if (evento.getClass() == Start.class) { // pronto -> inGara
					aggiornaKmPercorsi(0);
					ciclista.statoCorrente = Stato.IN_GARA;
					Environment.aggiungiEvento(new Corri(ciclista, ciclista));
				}
			break; // case PRONTO
			
			case IN_GARA:
				if (evento.getClass() == Corri.class) {
					if (arrivato()){// inGara -> finito
						// Cambia stato
						ciclista.statoCorrente = Stato.FINITO;
					}
					else{
						if (primo() && !arrivato()){ // inGara -> inTesta
							// Cambia stato
							ciclista.statoCorrente = Stato.IN_TESTA;
							
							// Invia l'evento
							Environment.aggiungiEvento(new Corri(ciclista, ciclista));			
							
							// Aggiorna i kilometri percorsi 
							TipoLinkPartecipa link = ciclista.getLinkPartecipa();
							float nuovaDistanza = link.getKmPercorsi() + (link.getGara().getDistanza()/100)*(1+(float)Math.random());
							aggiornaKmPercorsi(nuovaDistanza);							
						}
						else{
							if(!primo() && !arrivato()){ // inGara -> inGara
								// Lo stato non cambia
								
								// Invia l'evento
								Environment.aggiungiEvento(new Corri(ciclista, ciclista));					
								
								// Aggiorna i kilometri percorsi 
								TipoLinkPartecipa link = ciclista.getLinkPartecipa();
								float nuovaDistanza = link.getKmPercorsi() + (link.getGara().getDistanza()/100)*(float)(1+Math.random());
								aggiornaKmPercorsi(nuovaDistanza);
							}
						}
					}
				}
			break; // case IN_GARA
			
			case IN_TESTA:
				if (evento.getClass() == Corri.class) {
					if (arrivato()){// inTesta -> finito
						// Cambia stato
						ciclista.statoCorrente = Stato.FINITO;
					}
					else{
						if (primo() && !arrivato()){ // inTesta -> inTesta
							// Non cambia stato
							
							// Invia l'evento
							Environment.aggiungiEvento(new Corri(ciclista, ciclista));				
							
							// Aggiorna i kilometri percorsi 
							TipoLinkPartecipa link = ciclista.getLinkPartecipa();
							float nuovaDistanza = link.getKmPercorsi() + (link.getGara().getDistanza()/100)*(float)(1.1-Math.random());
							aggiornaKmPercorsi(nuovaDistanza);							
						}
						else{
							if(!primo() && !arrivato()){ // inTesta -> inGara
								// cambia stato
								ciclista.statoCorrente = Stato.IN_GARA;
								
								// Invia l'evento
								Environment.aggiungiEvento(new Corri(ciclista, ciclista));					
								
								// Aggiorna i kilometri percorsi 
								TipoLinkPartecipa link = ciclista.getLinkPartecipa();
								float nuovaDistanza = link.getKmPercorsi() + (link.getGara().getDistanza()/100)*(float)(1.1-Math.random());
								aggiornaKmPercorsi(nuovaDistanza);
							}
						}
					}
				}
			break; // case IN_TESTA			
		
			default:
				throw new RuntimeException("Stato corrente non riconosciuto.");
		}// switch (ciclista.getStato()) 
	}
	
	private void aggiornaKmPercorsi(float nuovaDistanza){
		// Metodo (privato) di servizio
		/* 
		 * Rimpiazza il link esistente tra gara e ciclista con uno equivalente 
		 * tale che kmPercorsi = nuovaDistanza
		 */
		Gara gara = ciclista.getLinkPartecipa().getGara();
		TipoLinkPartecipa nuovoLink = null;
		try{
			nuovoLink = new TipoLinkPartecipa(gara,ciclista,nuovaDistanza);
		}
		catch (EccezionePrecondizioni e){
			e.printStackTrace();
			System.exit(1);
		}
		ciclista.eliminaLinkPartecipa(nuovoLink);
		ciclista.inserisciLinkPartecipa(nuovoLink);
	}
	
	private boolean primo(){
		// Metodo (privato) di servizio
		/* Calcola la condizione primo
		 * Restituisce true se e solo se il ciclista ha percorso la distanza massima 
		 * tra i partecipanti alla sua stessa gara
		 */
		
		TipoLinkPartecipa link = ciclista.getLinkPartecipa();
		float miaDistanza = link.getKmPercorsi();
		Set<TipoLinkPartecipa> avversari = null;
		try{
			avversari = link.getGara().getLinkPartecipa();		
		}
		catch(EccezioneMoltMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		Iterator<TipoLinkPartecipa> it = avversari.iterator();
		while(it.hasNext()){
			TipoLinkPartecipa linkCorrente = it.next();
			if(linkCorrente.getKmPercorsi() > miaDistanza){// trovato un ciclista che ha percorso piu' km di quello corrente
				return false; 
			}
		}
		return true;
	}
	
	private boolean arrivato(){
		// Metodo (privato) di servizio
		/* Calcola la condizione arrivato
		 * Restituisce true se e solo se esiste un ciclista che ha percorso tutto il tratto partenza-traguardo 
		 * della gara a cui partecipa il cilista corrente
		 */

		Set<TipoLinkPartecipa> avversari = null;
		try{
			avversari = ciclista.getLinkPartecipa().getGara().getLinkPartecipa();
		}
		catch(EccezioneMoltMinMax e){
			e.printStackTrace();
			System.exit(1);
		}
		Iterator <TipoLinkPartecipa> it = avversari.iterator();
		while(it.hasNext()){
			if(it.next().getKmPercorsi() >= ciclista.getLinkPartecipa().getGara().getDistanza()){
				return true;
			}
		}
		return false;		
	}
		
	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
}
