package attivita_atomiche;

import java.util.*;

import _framework.*;
import ciclisti.*;
import ciclisti.partecipa.*;
import ciclisti.ciclista.*;

public class TestFineGara implements Task {
	private boolean eseguita = false;
	private Gara gara;
	private boolean inCorso = false;

	public TestFineGara(Gara gara) {
		this.gara = gara;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		
		Set<TipoLinkPartecipa> partecipanti = null;
		try{
			partecipanti = gara.getLinkPartecipa();
		}
		catch(EccezioneMoltMinMax eccezione){
			eccezione.printStackTrace();
			System.exit(1);
		}
		
		Iterator<TipoLinkPartecipa> it = partecipanti.iterator();
		while(it.hasNext() && !inCorso){
			if (it.next().getCiclista().getStato() != Ciclista.Stato.FINITO){
				inCorso = true;
			}
			// se non entra mai nell'if() risultato rimane false
		}
	}
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}

	public synchronized boolean getRisultato() {
		return inCorso;
	}
}
