package attivita_atomiche;

import ciclisti.*;
import ciclisti.partecipa.*;
import ciclisti.ciclista.*;
import _framework.*;

public class IscriviCiclista implements Task {
	private boolean eseguita = false;
	private Gara gara;
	private Ciclista ciclista;
	
	public IscriviCiclista(Gara gara, Ciclista ciclista) {
		this.gara=gara;
		this.ciclista=ciclista;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		
		TipoLinkPartecipa link=null;
		try {
			link = new TipoLinkPartecipa(gara, ciclista,0);
		} 
		catch (EccezionePrecondizioni eccezione){
			eccezione.printStackTrace();
			System.exit(1);
		}
		gara.inserisciLinkPartecipa(link);
	}
	
	public synchronized boolean estEseguita(){
		return eseguita;
	}
}
