package attivita_atomiche;

import java.util.*;

import ciclisti.*;
import ciclisti.ciclista.*;
import ciclisti.partecipa.*;
import eventi.*;
import _framework.*;
import _gestioneeventi.*;

public class AvviaGara implements Task {
	private boolean eseguita = false;
	private Gara gara;

	public AvviaGara(Gara gara) {
		this.gara = gara;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		Iterator<TipoLinkPartecipa> it = null;
		try{
			it = gara.getLinkPartecipa().iterator();
		}
		catch(EccezioneMoltMinMax eccezione){
			eccezione.printStackTrace();
			System.exit(1);
		}
		
		while (it.hasNext()) {
			Ciclista ciclista = it.next().getCiclista();
			EsecuzioneEnvironment.addListener(ciclista);
			Environment.aggiungiEvento(new Start(null,ciclista));// Va bene anche se in boradcast
		}
		
		
		
		EsecuzioneEnvironment.attivaListener();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
