package souvenir;

import java.util.*;

public class Scontrino 
{
	private static int numeroMax=0;
	
	private final int numero;
	private final Date data;
	private final HashSet<TipoLinkComprende> insiemeSouvenir=new HashSet<TipoLinkComprende>();
	
	public Scontrino()
	{
		numero=(++numeroMax);
		data=new Date();
	}

	public int getNumero() 
	{
		return numero;
	}

	public Date getData() 
	{
		return data;
	}
	
	public float totale()
	{
		float importo=0;
		Iterator<TipoLinkComprende> iter=insiemeSouvenir.iterator();
		while(iter.hasNext())
		{
			TipoLinkComprende elem=iter.next();
			importo+=elem.getQuantita()*elem.getSouvenir().getPrezzo();
		}
		return(importo);
	}
	
	public void inserisciLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getScontrino() == this)
			ManagerComprende.inserisci(t);
	}
	
	public void inserisciLinkPerManagerComprende(ManagerComprende k)
	{
		if (k!=null)
			insiemeSouvenir.add(k.getLink());
	}

	public void eliminaLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getScontrino() == this)
			ManagerComprende.elimina(t);
	}

	public void eliminaLinkPerManagerComprende(ManagerComprende k)
	{
		if (k!=null)
			insiemeSouvenir.remove(k.getLink());
	}
	
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkComprende> getLinkComprende()
	{
		return (Set<TipoLinkComprende>) insiemeSouvenir.clone();
	}
	
}
