package attivita_io;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.*;

import javax.swing.*;

public class VisioneScontrino extends JFrame 
{
	private JLabel numeroLbl=new JLabel("Numero scontrino: ");
	private JLabel dataLbl=new JLabel("Data: ");
	private JLabel totaleLbl=new JLabel("Totale: ");
	private JPanel okPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	private static final String intestazione[]={"Souvenir","Quantita'"};
	private JPanel centroPnl=new JPanel();
	
	private String[][] creaTabella(Set<RecordAcquisto> insieme)
	{
		Iterator<RecordAcquisto> iter=insieme.iterator();
		String[][] retValue=new String[insieme.size()][2];
		int i=0;
		while(iter.hasNext())
		{
			RecordAcquisto elem=iter.next();
			retValue[i][0]=elem.getDescrizione();
			retValue[i][1]=elem.getQuantita()+"";
			i++;
		}
		return(retValue);
	}
	
	public VisioneScontrino(RecordScontrino record) 
	{
		super("Scontrino");
		numeroLbl.setText(numeroLbl.getText()+record.getNumero());
		dataLbl.setText(dataLbl.getText()+record.getEmissione());
		totaleLbl.setText(totaleLbl.getText()+record.getTotale());
		centroPnl.add(numeroLbl);
		centroPnl.add(dataLbl);
		String[][] tab=creaTabella(record.getInsiemeRecord());
		centroPnl.add(new JScrollPane(new JTable(tab,intestazione)));
		centroPnl.add(totaleLbl);
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		okPnl.add(okBtn);
		okBtn.addActionListener(new VisioneScontrinoListener(this));
		getContentPane().add(okPnl,BorderLayout.SOUTH);
		setSize(480,570);
		setVisible(true);
	}

}
