package attivita_composte;

import souvenir.*;
import java.util.*;
import _framework.*;
import attivita_atomiche.*;
import attivita_io.*;

public class AttivitaSottoramoBerretti implements Runnable {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente=null;
	private boolean ancoraBerretti=true;
	private Set<String> berrettiLetti;	
	private RecordAcquisto berrettoSelezionato;
	
	public AttivitaSottoramoBerretti(Scontrino scontrinoCorrente){
		this.scontrinoCorrente=scontrinoCorrente;
	}
		
	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		
		while(ancoraBerretti){
			LeggiBerretti leggiBerretti = new LeggiBerretti();
			Executor.perform(leggiBerretti);
			
			berrettiLetti = leggiBerretti.getRisultato();
			
			berrettoSelezionato = AttivitaIO.mostraSouvenirPerSelezione(berrettiLetti);
			
			AggiornaScontrino aggiornaScontrino = new AggiornaScontrino(berrettoSelezionato, scontrinoCorrente);
			Executor.perform(aggiornaScontrino);
			
			ancoraBerretti = AttivitaIO.altroBerretto();
		}
	}
}
