package attivita_atomiche;

import java.util.*;

import souvenir.*;

import attivita_io.*;
import _framework.*;


public class AggiornaScontrino implements Task {
	private boolean eseguita=false;
	private Scontrino scontrinoCorrente;
	private RecordAcquisto recordAcquisto;
	
	public AggiornaScontrino(RecordAcquisto recordAcquisto, Scontrino scontrino){
		this.scontrinoCorrente = scontrino;
		this.recordAcquisto = recordAcquisto;
	}
	
	public synchronized void esegui(Executor e) {
		if (eseguita || e==null)
			return;
		eseguita = true;
		// A partire dalla descrizione dell'acquisto ottiene un riferimento al Souvenir acquistato
		// (Non possono esistere duplicati delle descrizioni)
		Souvenir souvenirAcquistato = Articoli.getSouvenirDaDescrizione(recordAcquisto.getDescrizione());
		try{
			TipoLinkComprende nuovoLink = new TipoLinkComprende(souvenirAcquistato, scontrinoCorrente, recordAcquisto.getQuantita());
			
			// Se e' gia' presente un link comprende tra scontrinoCorrente e souvenirAcquistato, deve essere rimpiazzato da un link analogo
			// con quantita' pari a quella del link presente pi la quantita' del souvenir acquistata 
			
			if (scontrinoCorrente.getLinkComprende().contains(nuovoLink)){
				Iterator<TipoLinkComprende> linkIt = scontrinoCorrente.getLinkComprende().iterator();
				TipoLinkComprende linkPresente=null;
				do{// Scorre l'insieme dei link fino a trovare il link gia' presente uguale a quello da inserire 
				// NOTA: le quantita' non sono rilevanti per equals()
					linkPresente = linkIt.next();
				}
				while(!linkPresente.equals(nuovoLink));
				
				//Rimpiazza il link gia' presente con quello nuovo
				scontrinoCorrente.eliminaLinkComprende(linkPresente);
				scontrinoCorrente.inserisciLinkComprende(new TipoLinkComprende(souvenirAcquistato, scontrinoCorrente, recordAcquisto.getQuantita()+linkPresente.getQuantita()));
			}
			else{
				//Altrimenti inerisce il nuovo link
				scontrinoCorrente.inserisciLinkComprende(nuovoLink);
			}
		}
		catch( EccezionePrecondizioni ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
	}
}



