package souvenir;

public class Magnete extends Souvenir
{
	private final int base, altezza;
	
	public Magnete(String localita, float prezzo, int base, int altezza) throws EccezionePrecondizioni 
	{
		super(localita, prezzo);
		if (base>0 && altezza >0){
			this.base=base;
			this.altezza=altezza;
		}
		else
			throw(new EccezionePrecondizioni("Base ed altezza devono avere valore positivo"));
	}

	public int getBase() {
		return base;
	}

	public int getAltezza() {
		return altezza;
	}
		
	public String toString(){
		return "Magnete " + getLocalita() + " ("+base+"x"+altezza+"): "+ getPrezzo();
	}
}
