package attivita_atomiche;

import java.util.*;

import souvenir.*;

import attivita_io.*;

import _framework.*;

public class LeggiScontrino implements Task {
	private boolean eseguita = false;
	private RecordScontrino recordScontrino;
	private Scontrino scontrino;
 	
	public LeggiScontrino(Scontrino scontrinoCorrente){
		scontrino = scontrinoCorrente;
	}
	
	public synchronized void esegui(Executor e) {
		if ( eseguita || e == null)
			return;
		eseguita = true;
		/* Accede allo scontrino corrente e costruisce il relativo 
		 * recordScontrino, contenente la lista di souvenir acquistati 
		 * e la spesa totale
		 */
		recordScontrino = new RecordScontrino(scontrino.getNumero(), scontrino.getData(), scontrino.totale());
		Set<TipoLinkComprende> souvenirAcquistati = scontrino.getLinkComprende();
		Iterator<TipoLinkComprende> souvenirIt = souvenirAcquistati.iterator();
		while (souvenirIt.hasNext()){
			TipoLinkComprende linkCorrente = souvenirIt.next();
			// Crea il RecordAcquisto associato all'acquisto corrente e lo inserisce in recordScontrino					
			recordScontrino.addRecord(new RecordAcquisto(linkCorrente.getSouvenir().toString(), linkCorrente.getQuantita()));
		}
	}
	
	public RecordScontrino getRisultato(){
		return recordScontrino;
	}
}
