package attivita_atomiche;

import _framework.*;
import attivita_io.*;

import java.util.*;

import souvenir.*;

public class LeggiMagneti implements Task {
	private boolean eseguita = false;
	private HashSet<String> listaMagneti=new HashSet<String>();
	
	public synchronized void esegui(Executor e) {
		if (eseguita || e==null)
			return;
		eseguita = true;
		Collection<Souvenir> listaSouvenir = Articoli.getListaSouvenir();
		Iterator<Souvenir> listaSouvenirIt = listaSouvenir.iterator();
		while(listaSouvenirIt.hasNext()){
			Souvenir souvenirCorrente = listaSouvenirIt.next();
			if (souvenirCorrente.getClass() == Magnete.class){
				listaMagneti.add(souvenirCorrente.toString());
			}
		}
	}
	
	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
	public Set<String> getRisultato(){
		if (!eseguita)
			throw new RuntimeException("Risultato non pronto!");		
		return (Set<String>) listaMagneti.clone();
	}
}
