package partecipaBlu;

import partita.*;
import giocatoreBlu.*;

public class TipoLinkPartecipaBlu {
	private final GiocatoreBlu giocatore;
	private final Partita partita;

	public TipoLinkPartecipaBlu(GiocatoreBlu x, Partita y) {
		if (x == null || y == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException(
					"Gli oggetti devono essere inizializzati");
		giocatore = x;
		partita = y;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPartecipaBlu b = (TipoLinkPartecipaBlu) o;
			return b.giocatore == giocatore && b.partita == partita;
		} else
			return false;
	}

	public int hashCode() {
		return partita.hashCode() + giocatore.hashCode();
	}

	public Partita getPartita() {
		return partita;
	}

	public GiocatoreBlu getGiocatore() {
		return giocatore;
	}
}
