package partecipaBlu;

import giocatore.*;

public final class ManagerPartecipaBlu {
	private ManagerPartecipaBlu(TipoLinkPartecipaBlu x) {
		link = x;
	}

	private TipoLinkPartecipaBlu link;

	public TipoLinkPartecipaBlu getLink() {
		return link;
	}

	public static void inserisci(TipoLinkPartecipaBlu y) {
		if (y != null && y.getGiocatore().quantiPartecipaBlu() == 0) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerPartecipaBlu k = new ManagerPartecipaBlu(y);
			y.getGiocatore().inserisciPerManagerPartecipaBlu(k);
			y.getPartita().inserisciPerManagerPartecipaBlu(k);
		}
	}

	public static void elimina(TipoLinkPartecipaBlu y) {
		if (y != null) {
			if (y.getGiocatore().getStato() != Giocatore.Stato.NONINGIOCO)
				throw new RuntimeException(
						"Non si puo' modificare un giocatore mentre sta giocando");
			ManagerPartecipaBlu k = new ManagerPartecipaBlu(y);
			y.getGiocatore().eliminaPerManagerPartecipaBlu(k);
			y.getPartita().eliminaPerManagerPartecipaBlu(k);
		}
	}
}
