package giocatoreVerde;

import partecipaVerde.*;
import giocatore.*;

public class GiocatoreVerde extends Giocatore {

	private TipoLinkPartecipaVerde link = null;
	
	public GiocatoreVerde(String nome, int eta){
		super(nome, eta);
	};
	
	public void inserisciLinkPartecipaVerde(TipoLinkPartecipaVerde t) {
		if (t != null && t.getGiocatore() == this)
			ManagerPartecipaVerde.inserisci(t);
	}

	public void eliminaLinkPartecipaVerde(TipoLinkPartecipaVerde t) {
		if (t != null && t.getGiocatore() == this)
			ManagerPartecipaVerde.elimina(t);
	}

	public TipoLinkPartecipaVerde getLinkPartecipaVerde() {
		return link;
	}

	public void inserisciPerManagerPartecipaVerde(ManagerPartecipaVerde a) {
		if (a != null)
			link = a.getLink();
	}

	public void eliminaPerManagerPartecipaVerde(ManagerPartecipaVerde a) {
		if (a != null)
			link = null;
	}

	public int quantiPartecipaVerde(){
		if (link == null)
			return 0;
		return 1;
	}
	
	public String toString(){
		return super.toString() + " (verde)";
	}
}
