package giocatore;

import java.util.*;
import eventi.*;
import giocatoreBlu.GiocatoreBlu;
import giocatoreVerde.GiocatoreVerde;
import _framework.*;
import _gestioneeventi.*;

class GiocatoreFired implements Task {
	private boolean eseguita = false;
	private Giocatore g;
	private Evento e;
	
	public GiocatoreFired(Giocatore g, Evento e) {
		this.g = g;
		this.e = e;
	}

	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null || (e.getDestinatario() != g && e.getDestinatario() != null))
			return;
		eseguita = true;
		Giocatore dest=null;
		
		switch (g.getStato()) {
		case NONINGIOCO:
			if (e.getClass() == InizioMusica.class) {
				g.statocorrente = Giocatore.Stato.INGIOCO;
			}
			break;
		case INGIOCO:
			if (e.getClass() == Passa.class) {
				if (g.getClass() == GiocatoreVerde.class){
					
					dest =  scegliBlu();
					
					Environment.aggiungiEvento(new Passa(g, dest));
				}
				else {
					
					
					dest = scegliVerde();
					
					
					Environment.aggiungiEvento(new Passa(g, dest));
				}
 
			} else if (e.getClass() == FineMusica.class)
				g.statocorrente = giocatore.Giocatore.Stato.NONINGIOCO;
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		if (dest!=null)
			System.out.println(g + " sceglie di lanciare a " + dest);
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
	

	// resituisce un giocatore blu scelto casualmente
	private GiocatoreBlu  scegliBlu() {
		Random r = new Random();
		int quantiBlu = ((GiocatoreVerde)g).getLinkPartecipaVerde().getPartita().quantiGiocatoriBlu();
		int passaA = r.nextInt(quantiBlu);
		
    	return ((GiocatoreVerde)g).getLinkPartecipaVerde().getPartita().
			getLinkPartecipaBlu().get(passaA).getGiocatore();		
    }
	
	// resituisce un giocatore verde scelto casualmente
	private GiocatoreVerde scegliVerde() {
		Random r = new Random();
		int quantiVerdi = ((GiocatoreBlu)g).getLinkPartecipaBlu().getPartita().quantiGiocatoriVerdi();
		int passaA = r.nextInt(quantiVerdi);
		
    	return ((GiocatoreBlu)g).getLinkPartecipaBlu().getPartita().
			getLinkPartecipaVerde().get(passaA).getGiocatore();		
    }
	
}
