package attivita_atomiche;

import giocatore.*;
import giocatoreBlu.GiocatoreBlu;
import giocatoreVerde.GiocatoreVerde;

import partecipaBlu.*;
import partecipaVerde.*;
import partita.*;

import _framework.Executor;
import _framework.Task;


public class InserisciGiocatore implements Task {

	private boolean eseguita = false;
	private Partita partita;
	private Giocatore giocatore;

	public InserisciGiocatore(Giocatore giocatore, Partita partita) {
		this.giocatore = giocatore;
		this.partita = partita;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;

		if(giocatore.getClass() == GiocatoreVerde.class){
			TipoLinkPartecipaVerde l = new TipoLinkPartecipaVerde((GiocatoreVerde)giocatore,partita);
			partita.inserisciLinkPartecipaVerde(l);
		}
		
		if(giocatore.getClass() == GiocatoreBlu.class){
			TipoLinkPartecipaBlu l = new TipoLinkPartecipaBlu((GiocatoreBlu)giocatore,partita);
			partita.inserisciLinkPartecipaBlu(l);
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}