package partita;

import java.util.*;

import partecipaBlu.*;
import partecipaVerde.*;

public class Partita {
	private final String nome;
	private ArrayList<TipoLinkPartecipaVerde> partecipantiVerdi;
	private ArrayList<TipoLinkPartecipaBlu> partecipantiBlu;
	public final int MIN_PARTECIPA = 1;

	public Partita(String nome) {
		this.nome = nome;
		partecipantiVerdi = new ArrayList<TipoLinkPartecipaVerde>();
		partecipantiBlu = new ArrayList<TipoLinkPartecipaBlu>();
	}

	public String getNome() {
		return nome;
	}

	public void inserisciLinkPartecipaVerde(TipoLinkPartecipaVerde t) {
		if (t != null && t.getPartita() == this)
			ManagerPartecipaVerde.inserisci(t);
	}

	public void eliminaLinkPartecipaVerde(TipoLinkPartecipaVerde t) {
		if (t != null && t.getPartita() == this)
			ManagerPartecipaVerde.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkPartecipaVerde> getLinkPartecipaVerde() {
		//DA COMPLETARE A CURA DEGLI STUDENTI. Sostituire la riga sotto con quelle giuste:
		return null;
	}

	public void inserisciPerManagerPartecipaVerde(ManagerPartecipaVerde a) {
		//DA COMPLETARE A CURA DEGLI STUDENTI.
	}

	public void eliminaPerManagerPartecipaVerde(ManagerPartecipaVerde a) {
		if (a != null)
			partecipantiVerdi.remove(a.getLink());
	}

	public int quantiGiocatoriVerdi() {
		return partecipantiVerdi.size();
	}

	public void inserisciLinkPartecipaBlu(TipoLinkPartecipaBlu t) {
		if (t != null && t.getPartita() == this)
			ManagerPartecipaBlu.inserisci(t);
	}

	public void eliminaLinkPartecipaBlu(TipoLinkPartecipaBlu t) {
		if (t != null && t.getPartita() == this)
			ManagerPartecipaBlu.elimina(t);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkPartecipaBlu> getLinkPartecipaBlu() {
		//DA COMPLETARE A CURA DEGLI STUDENTI. Sostituire la riga sotto con quelle giuste:
		return null;
	}

	public void inserisciPerManagerPartecipaBlu(ManagerPartecipaBlu a) {
		if (a != null && !partecipantiBlu.contains(a.getLink()))
			partecipantiBlu.add(a.getLink());
	}

	public void eliminaPerManagerPartecipaBlu(ManagerPartecipaBlu a) {
		if (a != null)
			partecipantiBlu.remove(a.getLink());
	}

	public int quantiGiocatoriBlu() {
		return partecipantiBlu.size();
	}

	public String toString() {
		return nome;
	}
}
