package giocatore;

import java.util.*;
import eventi.*;
import giocatoreBlu.GiocatoreBlu;
import giocatoreVerde.GiocatoreVerde;
import _framework.*;
import _gestioneeventi.*;

class GiocatoreFired implements Task {
	private boolean eseguita = false;
	private Giocatore g;
	private Evento e;
	
	public GiocatoreFired(Giocatore g, Evento e) {
		this.g = g;
		this.e = e;
	}

	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null || (e.getDestinatario() != g && e.getDestinatario() != null))
			return;
		eseguita = true;
		Giocatore dest=null; // giocatore a cui viene passato il cerino
		
		//DA COMPLETARE A CURA DEGLI STUDENTI		
		/*
		 * Per la scelta del prossimo giocatore blu o verde si raccomanda l'uso dei metodi privati
		 * scegliBlu() e scegliVerde() (vedi in fondo) che restituiscono, rispettivamente, il prossimo giocatore blu
		 * e verde a cui passare un cerino. 
		 */
			
		if (dest!=null){
			 /* Ad ogni iterazione, se il giocatore passa un cerino (cioe' dest != null), 
			  * si stampano in output il mittente ed il destinatario del cerino
			  */ 
			System.out.println(g + " sceglie di lanciare a " + dest);
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
	

	// resituisce un giocatore blu scelto casualmente
	private GiocatoreBlu  scegliBlu() {
		Random r = new Random();
		int quantiBlu = ((GiocatoreVerde)g).getLinkPartecipaVerde().getPartita().quantiGiocatoriBlu();
		int passaA = r.nextInt(quantiBlu);
		
    	return ((GiocatoreVerde)g).getLinkPartecipaVerde().getPartita().
			getLinkPartecipaBlu().get(passaA).getGiocatore();		
    }
	
	// resituisce un giocatore verde scelto casualmente
	private GiocatoreVerde scegliVerde() {
		Random r = new Random();
		int quantiVerdi = ((GiocatoreBlu)g).getLinkPartecipaBlu().getPartita().quantiGiocatoriVerdi();
		int passaA = r.nextInt(quantiVerdi);
		
    	return ((GiocatoreBlu)g).getLinkPartecipaBlu().getPartita().
			getLinkPartecipaVerde().get(passaA).getGiocatore();		
    }
	
}
