package attivita_io;

import partita.*;
import partitaMulti.*;
import javax.swing.*;

import _gestioneeventi.EsecuzioneEnvironment;
import giocatoreBlu.*;
import giocatoreVerde.*;

public class AttivitaIO 
{
	
	public static void FermaMusica() {
		JOptionPane.showMessageDialog(null,
				"Click su OK per fermare il gioco", "Attendi segnale",
				JOptionPane.INFORMATION_MESSAGE);
	}
	
	public static Partita LeggiDatiPartita() {
		String nomePartita = null;
		do{
			nomePartita = JOptionPane.showInputDialog(null,"Inserisci il nome della partita");
		}
		while (nomePartita==null);
		int numCerini = 0;
		do{
			numCerini = Integer.parseInt(JOptionPane.showInputDialog(null,"Con quanti cerini vuoi giocare?"));		
		}
		while(numCerini<=0);
		
		if (numCerini == 1){
			return new Partita(nomePartita);
		}
		
		return new PartitaMulti(nomePartita,numCerini);
	}
	
	public static GiocatoreBlu LeggiDatiGiocatoreBlu() {
		String nomeGiocatore = JOptionPane.showInputDialog(null,"Inserisci il nome del prossimo giocatore blu");
		if (nomeGiocatore==null)
			return null;
		boolean ok=false;
		int etaGiocatore=0;
		while(!ok)
		{
			try {
				etaGiocatore = Integer.parseInt(JOptionPane.showInputDialog(null,"Inserisci l'eta'"));
				ok=true;
			} catch (NumberFormatException e) {
			} 
			
		}
		return new GiocatoreBlu(nomeGiocatore, etaGiocatore);
	}
	
	public static GiocatoreVerde LeggiDatiGiocatoreVerde() {
		String nomeGiocatore = JOptionPane.showInputDialog(null,"Inserisci il nome del prossimo giocatore verde");
		if (nomeGiocatore==null)
			return null;
		boolean ok=false;
		int etaGiocatore=0;
		while(!ok)
		{
			try 
			{
				etaGiocatore = Integer.parseInt(JOptionPane.showInputDialog(null,"Inserisci l'eta'"));
				ok=true;
			} 
			catch (NumberFormatException e) 
			{
			} 
		}	
		return new GiocatoreVerde(nomeGiocatore, etaGiocatore);
	}	
}
