package attivita_composte;

import giocatoreBlu.GiocatoreBlu;
import giocatoreVerde.GiocatoreVerde;

import attivita_io.*;

import partita.Partita;

import _framework.Executor;
import _gestioneeventi.EsecuzioneEnvironment;
import attivita_atomiche.*;

public class AttivitaPrincipale implements Runnable {

	private boolean eseguita = false;
	private Partita partita;
	private boolean altroGiocatore = false;

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		
		partita = AttivitaIO.LeggiDatiPartita();
		
		do{// Squadra blu
			GiocatoreBlu g = AttivitaIO.LeggiDatiGiocatoreBlu();
			
			altroGiocatore = (g != null);
			
			if(altroGiocatore){
				InserisciGiocatore inserisciGiocatore = new InserisciGiocatore(g,partita);
				Executor.perform(inserisciGiocatore);
			}
		}
		while(altroGiocatore);
		
		do{// Squadra verde
			GiocatoreVerde g = AttivitaIO.LeggiDatiGiocatoreVerde();
			
			altroGiocatore = (g != null);
			
			if(altroGiocatore){
				InserisciGiocatore inserisciGiocatore = new InserisciGiocatore(g,partita);
				Executor.perform(inserisciGiocatore);
			}
		}
		while(altroGiocatore);
		
	
		//DA COMPLETARE A CURA DEGLI STUDENTI
		
		EsecuzioneEnvironment.disattivaListener(); // (Lasciare qui come ultima istruzione)
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
