package processo;

import _framework.Executor;
import gui.Attesa;
import gui.AttivitaIO;
import gui.RecordPratica;
import officina.Riparazione;

public class SottoramoMeccanica implements Runnable {

	private boolean eseguita=false;
	private Riparazione pratica;

	public SottoramoMeccanica(Riparazione ripa) 
	{
		this.pratica=ripa;
	}

//	@Override
	public synchronized void run() 
	{
		if (eseguita)
			return;
		eseguita=true;
		AttivitaIO.aspetta(new Attesa<Riparazione>("Inserisci dati riparazione della meccanica",pratica));
		RecordPratica record=AttivitaIO.leggiRiparazioneMeccanica(pratica);
		ModificaMeccanica m=new ModificaMeccanica(pratica,record);
		Executor.perform(m);
	}

}
