package processo;

import gui.Attesa;
import gui.AttivitaIO;
import officina.*;

public class SottoramoLeggiRichiesta implements Runnable {
	private Riparazione pratica;
	private boolean eseguita= false;

	public SottoramoLeggiRichiesta(Riparazione pratica) {
		this.pratica = pratica;
	}

	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		
		AttivitaIO.aspetta(new Attesa<Riparazione>("Richiesta supporto",pratica));
		boolean richiesta = AttivitaIO.verificaRichiestaSupporto();		
		
		if (richiesta){// Richiama il corpo di AttivitaRichiestPersonale
			AttivitaRichiestaPersonale acrp = new AttivitaRichiestaPersonale(pratica);
			acrp.run();
		}
	}
}
