package processo;

import officina.EccezionePrecondizioni;
import officina.Riparazione;
import _framework.*;

public class RichiediSupporto implements Task {
	// Percentuale aggiuntiva dell'importo per la riparazione, dovuta al personale di supporto
	private final float PERCENTUALE_SUPPORTO = 10;
	
	private Riparazione pratica;
	
	public RichiediSupporto(Riparazione pratica) 
	{
		this.pratica=pratica;
	}

	public synchronized void esegui(Executor e) 
	{	
		try{
			float importoCorrente = pratica.getImporto();
			System.out.print("L'importo e' aumentato da "+ importoCorrente +" ");
			pratica.setImporto(importoCorrente*(1+PERCENTUALE_SUPPORTO/100));
			System.out.println("a " + pratica.getImporto()+ ", per richiesta manodopera di supporto");
		}
		catch (EccezionePrecondizioni ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
	}
}
