package gui;

import java.awt.BorderLayout;
import java.util.*;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;

import officina.EccezioneCardMinMax;
import officina.Riparazione;

class ListaAttesaTableModel extends AbstractTableModel
{
	private static final long serialVersionUID = 1L;
	private Attesa<Riparazione> elementi[];
	
	@SuppressWarnings("unchecked")
	public ListaAttesaTableModel()
	{
		SortedSet<Attesa<Riparazione>> lista = AttivitaIO.getLista();
		elementi=new Attesa[lista.size()];
		int i=0;
		Iterator<Attesa<Riparazione>> iter=lista.iterator();
		while(iter.hasNext())
			elementi[i++]=iter.next();
	}
	
	public int getColumnCount() 
	{
		return 3;
	}

	public int getRowCount() {
		return(elementi.length);
	}

	public Object getValueAt(int riga, int colonna) 
	{
		Attesa<Riparazione> elem=elementi[riga];
		switch(colonna)
		{
		case 0:
			return(elem.getInformazione());
		case 1:
			try {
				return(elem.getDatiAddizionali().getLink().getVeicolo());
			} catch (EccezioneCardMinMax e) {
				return "";
			}
		case 2:
			return(elem.getAttesaData());
		default:
			return(null);
		}
	}
	
    public String getColumnName(int colonna) 
    {
		switch(colonna)
		{
		case 0:
			return("Descrizione");
		case 1:
			return("Veicolo");
		case 2:
			return("Data creazione attivit");
		default:
			return("");
		}
    }
	
	public Attesa<Riparazione> getAttesaElem(int riga)
	{
		return(elementi[riga]);
	}	
}


public class ListaAttesaFrame extends JFrame
{
	private JTable tabella;
	private JButton okBtn=new JButton("OK");
	private JPanel okPnl=new JPanel();
	private ListaAttesaTableModel tm=new ListaAttesaTableModel();
	private ListaAttesaListener ascoltatore=new ListaAttesaListener(this);
	
	public Attesa<Riparazione> getElementoSelezionato()
	{
		return(tm.getAttesaElem(tabella.getSelectedRow()));
	}
	
	public ListaAttesaFrame()
	{
		super("Attivit in lista di attesa");
		tabella=new JTable(tm);
		this.getContentPane().add(new JScrollPane(tabella),BorderLayout.CENTER);
		okPnl.add(okBtn);
		okBtn.addActionListener(ascoltatore);
		this.getContentPane().add(okBtn, BorderLayout.SOUTH);
		pack();
		setVisible(true);
		
	}
}
