package gui;

import java.util.*;
import javax.swing.*;

import officina.Riparazione;

public class AttivitaIO 
{
	private static final TreeSet<Attesa<Riparazione>> lista=new TreeSet<Attesa<Riparazione>>(); 
	
	public static RecordPratica leggiDatiPratica(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_NONE));
	}

	public static RecordPratica leggiValutazioneDanni(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_CARROZZERIA+PraticaFrame.ENABLED_MECCANICA));
	}

	public static RecordPratica leggiRiparazioneMeccanica(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_MECCANICA));
	}
	
	public static RecordPratica leggiRiparazioneCarrozzeria(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_CARROZZERIA));
	}
	
	public static boolean verificaRichiestaSupporto()
	{// Restituisce true sse l'utente richiede supporto		
		return JOptionPane.showConfirmDialog(null,"Hai bisogno di personale di supporto?","",JOptionPane.YES_NO_OPTION)==JOptionPane.YES_OPTION;
	}
	

	private static RecordPratica apriFinestra(Riparazione rip, int constante)
	{
		PraticaFrame frame=new PraticaFrame(rip, constante);
		synchronized(frame)
		{
			try {
				frame.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		}
		return frame.getRis();
	}

	
	@SuppressWarnings("unchecked")
	public static SortedSet<Attesa<Riparazione>> getLista() 
	{
		synchronized(lista)
		{
			return (SortedSet<Attesa<Riparazione>>) (lista.clone());
		}
	}

	public static void aspetta(Attesa<Riparazione> attElem)
	{
		boolean ok;
		synchronized(lista)
		{
			ok=lista.add(attElem);
		}
		synchronized(attElem)
		{
			try {
				attElem.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		}
	}

	public static void notifica(Attesa<Riparazione> attElem)
	{
		boolean ok;
		synchronized(lista)
		{
			ok=lista.remove(attElem);
		}
		synchronized(attElem)
		{
			attElem.notify();
		}
	}
}
