package gui;

import java.util.Date;

public class Attesa<T> implements Comparable<Attesa<T>>
{
	private final Date attesaData=new Date();
	private final String informazione;
	private final T datiAddizionali;
	
	public Attesa(String informazione, T datiAddizionali)
	{
		this.informazione=informazione;
		this.datiAddizionali=datiAddizionali;
	}
	
	public int compareTo(Attesa<T> altro) 
	{
		int retValue=attesaData.compareTo(altro.attesaData);
		if (retValue==0)
			retValue=informazione.compareTo(altro.informazione);
		return(retValue);
	}
	
	public String toString()
	{
		return(informazione);
	}

	public Date getAttesaData() {
		return attesaData;
	}

	public String getInformazione() {
		return informazione;
	}

	public T getDatiAddizionali() {
		return datiAddizionali;
	}
}
