package processo;

import gui.RecordPratica;
import officina.EccezionePrecondizioni;
import officina.Riparazione;
import _framework.Executor;
import _framework.Task;

public class EffettuaValutazione implements Task 
{
	private Riparazione pratica;
	private RecordPratica record;
	
	public EffettuaValutazione(Riparazione ripa, RecordPratica record) 
	{		
		this.pratica=ripa;
		this.record=record;
	}

	@Override
	public void esegui(Executor e) 
	{	
		pratica.setCarrozzeriaDanneggiata(record.isCarrozzeriaDanneggiata());
		pratica.setMeccanicaDanneggiata(record.isMeccanicaDanneggiata());
		try {
			pratica.setDescrizione(record.getDescrizione());
		} catch (EccezionePrecondizioni e1) {
			e1.printStackTrace();
		}
	}

}
