package processo;

import _framework.Executor;
import gui.AttivitaIO;
import gui.RecordPratica;
import officina.Riparazione;

public class AttivitaRipMeccanica implements Runnable {

	private boolean eseguita=false;
	private Riparazione pratica;

	public AttivitaRipMeccanica(Riparazione ripa) 
	{
		this.pratica=ripa;
	}

	@Override
	public synchronized void run() 
	{
		if (eseguita)
			return;
		eseguita=true;
		RecordPratica record=AttivitaIO.leggiRiparazioneMeccanica(pratica);
		ModificaMeccanica m=new ModificaMeccanica(pratica,record);
		Executor.perform(m);
	}

}
