package officina;

import java.util.*;

public class Veicolo {
	private static final int MOLT_MIN = 1;
	private final String targa;
	private final String proprietario;
	private final HashSet<TipoLinkCoinvolto> linkCoinvolto=new HashSet<TipoLinkCoinvolto>();

	public Veicolo(String targa, String proprietario)
	{
		this.targa=targa;
		this.proprietario=proprietario;
	}
	
	public String getTarga() {
		return targa;
	}
	public String getProprietario() {
		return proprietario;
	}
	
	public void inserisciLinkPerManagerCoinvolto(ManagerCoinvolto manager)
	{
		if (manager!=null)
			linkCoinvolto.add(manager.getLink());
	}

	@SuppressWarnings("unchecked")
	public Set<TipoLinkCoinvolto> getLinkCoinvolto() throws EccezioneCardMinMax 
	{
		if (linkCoinvolto.size()<MOLT_MIN)
			throw(new EccezioneCardMinMax("Eccezione cardinalit minima"));
		return (Set<TipoLinkCoinvolto>)linkCoinvolto.clone();
	}
	
	public String toString()
	{
		return (targa+" ("+proprietario+")");
	}
}
