package gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;

import javax.swing.*;

import officina.EccezioneCardMinMax;
import officina.EccezionePrecondizioni;
import officina.Riparazione;


public class PraticaFrame extends JFrame
{
	private JLabel descrizioneLbl=new JLabel("Descrizione:");
	private JTextArea descrizioneTxt=new JTextArea(5,30);
	private JPanel descrizionePnl=new JPanel();
	private JLabel importoLbl=new JLabel("Importo Riparazione:");
	private JTextField importoTxt=new JTextField(8);
	private JPanel importoPnl=new JPanel();
	private JLabel aperturaLbl=new JLabel("Apertura Pratica:");
	private JLabel aperturaDataLbl=new JLabel();
	private JPanel aperturaPnl=new JPanel();	
	private JLabel veicoloLbl=new JLabel("Veicolo:");
	private JLabel veicoloLbl2=new JLabel();
	private JPanel veicoloPnl=new JPanel();
	private JCheckBox carrozzeriaDanneggiataCbx=new JCheckBox("Carrozzeria Danneggiata");
	private JCheckBox meccanicaDanneggiataCbx=new JCheckBox("Meccanica Danneggiata");	
	private JPanel centroPnl=new JPanel();
	private JPanel sudPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	private PraticaListener listener=new PraticaListener(this);
	public final static int ENABLED_IMPORTO=0;
	public final static int ENABLED_CARROZZERIA=1;
	public final static int ENABLED_MECCANICA=2;
	public static final int ENABLED_NONE = 4;
	
	public PraticaFrame(Riparazione pratica, int enabled) 
	{
		super("Pratica");
		riempiCampi(pratica);
		descrizionePnl.add(descrizioneLbl);
		descrizionePnl.add(new JScrollPane(descrizioneTxt));
		centroPnl.add(descrizionePnl);
		importoPnl.add(importoLbl);
		importoPnl.add(importoTxt);
		centroPnl.add(importoPnl);
		aperturaPnl.add(aperturaLbl);
		aperturaPnl.add(aperturaDataLbl);
		centroPnl.setLayout(new FlowLayout(FlowLayout.LEFT));
		centroPnl.add(aperturaPnl);
		centroPnl.add(carrozzeriaDanneggiataCbx);
		centroPnl.add(meccanicaDanneggiataCbx);
		veicoloPnl.add(veicoloLbl);
		veicoloPnl.add(veicoloLbl2);
		centroPnl.add(veicoloPnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(listener);
		switch(enabled)
		{
		case ENABLED_IMPORTO:
			carrozzeriaDanneggiataCbx.setEnabled(false);
			meccanicaDanneggiataCbx.setEnabled(false);
			break;
		case ENABLED_CARROZZERIA:
			importoTxt.setEnabled(false);
			meccanicaDanneggiataCbx.setEnabled(false);
			break;
		case ENABLED_MECCANICA:
			importoTxt.setEnabled(false);
			carrozzeriaDanneggiataCbx.setEnabled(false);
			break;
		case ENABLED_CARROZZERIA+ENABLED_MECCANICA:
			importoTxt.setEnabled(false);
			break;
		case ENABLED_NONE:
			importoTxt.setEnabled(false);
			carrozzeriaDanneggiataCbx.setEnabled(false);
			meccanicaDanneggiataCbx.setEnabled(false);
			break;
			
		default:
			throw new IllegalArgumentException();
		}
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);		
		this.setSize(458,305);
		this.setVisible(true);
	}

	private void riempiCampi(Riparazione pratica) {
		descrizioneTxt.setText(pratica.getDescrizione());
		importoTxt.setText(String.valueOf(pratica.getImporto()));
		aperturaDataLbl.setText(pratica.getAperturaPratica().toString());
		carrozzeriaDanneggiataCbx.setSelected(pratica.isCarrozzeriaDanneggiata());
		meccanicaDanneggiataCbx.setSelected(pratica.isMeccanicaDanneggiata());
		try {
			veicoloLbl2.setText(pratica.getLink().getVeicolo().toString());
		} 
		catch (EccezioneCardMinMax e) 
		{
			veicoloLbl2.setText("** ERRORE **");
		}
	}
	
	public RecordPratica getRis()
	{
		RecordPratica record=new RecordPratica();
		try {
			record.setDescrizione(descrizioneTxt.getText());
			record.setCarrozzeriaDanneggiata(carrozzeriaDanneggiataCbx
					.isSelected());
			record.setMeccanicaDanneggiata(meccanicaDanneggiataCbx
					.isSelected());
			
			record.setImporto(Float.parseFloat(importoTxt.getText()));
			return (record);
		} catch (EccezionePrecondizioni e) {
			e.printStackTrace();
			return(record);
		} catch(NumberFormatException e)
		{
			e.printStackTrace();
			return(record);
		}
	}
}
