package gui;

import officina.Riparazione;

public class AttivitaIO 
{
	public static RecordPratica leggiDatiPratica(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_NONE));
	}

	public static RecordPratica leggiValutazioneDanni(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_CARROZZERIA+PraticaFrame.ENABLED_MECCANICA));
	}

	public static RecordPratica leggiRiparazioneMeccanica(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_MECCANICA));
	}
	
	public static RecordPratica leggiRiparazioneCarrozzeria(Riparazione rip)
	{
		return(apriFinestra(rip,PraticaFrame.ENABLED_CARROZZERIA));
	}

	
	private static RecordPratica apriFinestra(Riparazione rip, int constante)
	{
		PraticaFrame frame=new PraticaFrame(rip, constante);
		synchronized(frame)
		{
			try {
				frame.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				System.exit(1);
			}
		}
		return frame.getRis();
	}
}
