package gui;

import java.awt.GridLayout;

import javax.swing.*;

public class PrincipaleFrame extends JFrame 
{
	private JButton aggPersonaBtn=new JButton("Aggiungi Persona all'archivio");
	private JButton aggPersonaPartitoBtn=new JButton("Iscrivi persone a partiti");
	private JButton aggPartitoBtn=new JButton("Aggiungi Partito all'archivio");
	private JButton aggPersonaGiuntaBtn=new JButton("Aggiungi persona a giunta regionale");
	private JButton aggRegioneBtn=new JButton("Aggiungi giunta regionale");
	private PrincipaleListener listener=new PrincipaleListener(this);
	private Modello modello;
	
	public Modello getModello()
	{
		return(modello);
	}
	
	public PrincipaleFrame(Modello m)
	{
		super("Finestra Principale");
		this.getContentPane().setLayout(new GridLayout(5,1));
		this.getContentPane().add(aggPersonaBtn);
		this.getContentPane().add(aggPersonaPartitoBtn);
		this.getContentPane().add(aggPartitoBtn);
		this.getContentPane().add(aggPersonaGiuntaBtn);
		this.getContentPane().add(aggRegioneBtn);
		aggPersonaBtn.addActionListener(listener);
		aggPersonaBtn.setActionCommand(PrincipaleListener.AGGPERSONA);
		aggPersonaPartitoBtn.addActionListener(listener);
		aggPersonaPartitoBtn.setActionCommand(PrincipaleListener.AGGPERSONAPARTITO);
		aggPartitoBtn.addActionListener(listener);
		aggPartitoBtn.setActionCommand(PrincipaleListener.AGGPARTITO);
		aggPersonaGiuntaBtn.addActionListener(listener);
		aggPersonaGiuntaBtn.setActionCommand(PrincipaleListener.AGGPERSONAREGIONE);
		aggRegioneBtn.addActionListener(listener);
		aggRegioneBtn.setActionCommand(PrincipaleListener.AGGREGIONE);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		pack();
		setResizable(false);
		setVisible(true);
		modello=m;
	}
}
