package gui;

import giunte.*;

import java.util.*;


public final class Modello 
{
	/**
	 * Questa HashMap mantiene la lista dei partiti con cui il diagramma delle classi  stato popolato.
	 * I partiti sono indicizzati su una stringa che ne identificano il nome (che si suppone univoco).
	 * L'uso delle mappe invece che dei semplici Set  motivato dalla volont di garantire una maggiore
	 * efficienza nella verifica della presenza di un partito con lo stesso nome per evitare l'aggiunta di elementi duplicati. 
	 */
	private Map<String,Partito> partiti = new HashMap<String,Partito>();

	/**
	 * Questa HashMap mantiene la lista delle regioni i con cui il diagramma delle classi  stato popolato.
	 * Le regioni sono indicizzate su una stringa che ne identificano il nome (che si suppone univoco).
	 * L'uso delle mappe invece che dei semplici Set  motivato dalla volont di garantire una maggiore
	 * efficienza nella verifica della presenza di una regione con lo stesso nome per evitare l'aggiunta di elementi duplicati. 
	 */	
	private Map<String,Regione> regioni= new HashMap<String,Regione>();
	
	/**
	 * Questa HashMap mantiene la lista delle regioni i con cui il diagramma delle classi stato popolato.
	 * Le regioni sono indicizzate su una tipo Nominativo. Il tipo Nominativo  caratterizzato da due propriet
	 * stringa Nome e Cognome; per tale tipo sono stati ridefiniti equals() and hashCode() in modo tale che due
	 * valori sono considerati uguali se le propriet Nome e Cognome hanno lo stesso valore.
	 * L'uso delle mappe invece che dei semplici Set  motivato dalla volont di garantire una maggiore
	 * efficienza nella verifica della presenza di una persona con lo stesso nome e cognome 
	 * per evitare l'aggiunta di elementi duplicati. 
	 */		
	private Map<Nominativo,Persona> persone= new HashMap<Nominativo,Persona>();

	/**
	 * Restitusce la lista dei partiti aggiunti
	 * @return Un oggetto che implementa l'interfaccia <i>java.util.Collection</i>
	 * che contiene tutti gli oggetti della classe Partito con cui il diagramma  stato popolato.
	 * La collezione  restituita immutabile: non  possibile modificarla, aggiungendo
	 * o rimuovendo elementi, n direttamente n attraverso gli iteratori.  
	 */
	public Collection<Partito> getPartiti()
	{
		Collection<Partito> unMod=Collections.unmodifiableCollection(partiti.values());
		return(unMod);
	}

	/**
	 * Restitusce la lista delle persone aggiunte.
	 * @return Un oggetto che implementa l'interfaccia <i>java.util.Collection</i>
	 * che contiene tutti gli oggetti della classe Persona con cui il diagramma  stato popolato.
	 * La collezione  restituita immutabile: non  possibile modificarla, aggiungendo
	 * o rimuovendo elementi, n direttamente n attraverso gli iteratori.  
	 */
	public Collection<Persona> getPersone()
	{
		Collection<Persona> unMod=Collections.unmodifiableCollection(persone.values());
		return(unMod);	
	}
	
	/**
	 * Restitusce la lista delle regioni aggiunte.
	 * @return Un oggetto che implementa l'interfaccia <i>java.util.Collection</i>
	 * che contiene tutti gli oggetti della classe Regione con cui il diagramma  stato popolato.
	 * La collezione  restituita immutabile: non  possibile modificarla, aggiungendo
	 * o rimuovendo elementi, n direttamente n attraverso gli iteratori.  
	 */	
	public Collection<Regione> getRegioni()
	{
		Collection<Regione> unMod=Collections.unmodifiableCollection(regioni.values());
		return(unMod);	
	}
	
	/**
	 * Popola il diagramma degli oggetti con un nuovo partito
	 * @param partito L'oggetto Partito da aggiungere
	 * @throws EccezionePrecondizioni L'eccezione  lanciata se esiste gi
	 * un partito con lo stesso nome. In tal caso, il partito non viene aggiunto.
	 */
	public void addPartito(Partito partito) throws EccezionePrecondizioni
	{
		//DA COMPLETARE A CURA DEGLI STUDENTI;
	}

	/**
	 * Popola il diagramma degli oggetti con una nuova regione
	 * @param regione L'oggetto Regione da aggiungere
	 * @throws EccezionePrecondizioni L'eccezione  lanciata se esiste gi
	 * una regione con lo stesso nome. In tal caso, la regione non viene aggiunta.
	 */	
	public void addRegione(Regione regione) throws EccezionePrecondizioni
	{
		boolean esiste=regioni.containsKey(regione.getNome());
		if(!esiste)
			regioni.put(regione.getNome(), regione);
		else
			throw(new EccezionePrecondizioni("La regione "+regione+" esiste gi"));

	}	

	/**
	 * Popola il diagramma degli oggetti con una nuova persona
	 * @param regione L'oggetto Partito da aggiungere
	 * @throws EccezionePrecondizioni L'eccezione  lanciata se esiste gi
	 * una regione con lo stesso nome. In tal caso, la persona non viene aggiunta.
	 */	
	public void addPersona(Persona persona) throws EccezionePrecondizioni
	{
		Nominativo nome=new Nominativo(persona.getNome(),persona.getCognome());
		boolean esiste=persone.containsKey(nome);
		if(!esiste)
			persone.put(nome, persona);
		if (esiste)
			throw(new EccezionePrecondizioni("Esiste gi una persona con lo stesso nome e cognome"));
	}	
	
	/**
	 * Aggiunge una associazione tra una data persona e un dato partito, specificando 
	 * l'attributo dell'associazione annoIscrizione
	 * @param persona L'oggetto Persona coinvolto nell'associazione 
	 * @param partito L'oggetto Partito coinvolto nell'associazione
	 * @param annoIscrizione L'anno di iscrizione al partito.
	 * @throws EccezionePrecondizioni L'eccezione  lanciata se la persona o il partito non sono oggetti
	 * con cui il diagramma delle classi  stato popolato.
	 */
	public void addPersonaPartito(Persona persona,Partito partito,int annoIscrizione)
		throws EccezionePrecondizioni
	{
		Nominativo nomin=new Nominativo(persona.getNome(),persona.getCognome());
		if (persone.containsKey(nomin) && partiti.containsKey(partito.getNome()))
		{
			TipoLinkIscritto link=new TipoLinkIscritto(partito, persona, annoIscrizione);
			persona.inserisciLinkIscritto(link);
		}
		else
			throw(new EccezionePrecondizioni("La persona "+persona+ "o il partito "+partito+" non esiste"));
	}
	
	/**
	 * Aggiunge una associazione tra una data persona e un data regione, specificando 
	 * l'attributo dell'associazione annoElezione.
	 * @param persona L'oggetto Persona coinvolto nell'associazione 
	 * @param regione L'oggetto Regione coinvolto nell'associazione
	 * @param annoElezione L'anno di elezione alla giunta di tale regione.
	 * @throws EccezionePrecondizioni L'eccezione  lanciata se la persona o la regione non sono oggetti
	 * con cui il diagramma delle classi  stato popolato.
	 */	
	public void addPersonaGiunta(Persona persona,Regione regione,int annoElezione)
	throws EccezionePrecondizioni
	{
		//DA COMPLETARE A CURA DEGLI STUDENTI
	}
}

