package gui;

import giunte.*;

import java.awt.BorderLayout;
import java.util.*;

import javax.swing.*;



public class InfoGiuntaFrame extends JFrame
{
	private JTable tabella;
	private final static Object[] intestazioni=
		{"Persona","Anno Elezione"};
	private final JLabel infoLabel;
	
	/**
	 * Data una regione, restituisce una matrice in cui ogni riga  composta da due colonne:
	 * 1) La persona membro della giunta
	 * 2) L'anno di elezione. 
	 * @param r La regione per cui costruire la matriec
	 * @return La matrice da mostra nella JTable
	 */
	private Object[][] dammiMatrice(Regione r)
	{
		Set<TipoLinkGiunta> insieme=r.getGiunta();
		Object[][] ritorno=new Object[insieme.size()][2];
		//DA COMPLETARE A CURA DEGLI STUDENTI
		return(ritorno);
	}
	
	/**
	 * Costruisce una finestra informativa sulle regioni. 
	 * @param r La regione di cui mostrare le informazioni
	 */
	public InfoGiuntaFrame(Regione r)
	{
		super("Informazione relative a"+r);
		Object[][] dati=dammiMatrice(r);
		tabella=new JTable(dati,intestazioni);
		this.getContentPane().add(new JScrollPane(tabella),BorderLayout.CENTER);
		Utility.centraFrame(this);
		String text="";
		if (r.getGiunta().size()>0)
		{
			Partito p=Operazioni.monocolore(r);
			if (p!=null)
				text="Giunta composta da membri afferenti allo stesso partito "+p;
			else
				text="Giunta multi-partitica";
		}
		infoLabel=new JLabel(text);
		this.getContentPane().add(infoLabel,BorderLayout.SOUTH);
		setSize(300,300);
		setVisible(true);
	}
	
	
	
}
