package gui;

import giunte.EccezionePrecondizioni;
import giunte.Persona;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;



public class AggiungiPersonaListener implements ActionListener 
{
	private AggiungiPersonaFrame frame;
	
	public AggiungiPersonaListener(AggiungiPersonaFrame unFrame)
	{
		this.frame=unFrame;
	}
	
	
	public void actionPerformed(ActionEvent ae) 
	{
		try {
			InfoAggiungiPersona info=frame.getInformazioni();
			int gg=Integer.parseInt(info.getGGNascita());
			int mm=Integer.parseInt(info.getMMNascita());
			int aa=Integer.parseInt(info.getAANascita());
			Persona p=new Persona(info.getNome(), info.getCognome(), gg, mm, aa);
			frame.getModello().addPersona(p);
			Utility.messaggioAvviso(frame, "La persona "+p+ "  stata aggiunta.");
			frame.reset();
		} 
		catch (NumberFormatException e) {
			Utility.messaggioErrore(frame, "Data di nascita non valida");
		} 
		catch (EccezionePrecondizioni e) 
		{
			Utility.messaggioErrore(frame, e.getMessage());
		}
	}

}
