package gui;

import giunte.*;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.*;



class InfoAggiungiPersonaGiunta
{
	private Persona persona;
	private Regione regione;
	private String annoElezione;
	
	public InfoAggiungiPersonaGiunta(Persona unaPersona,Regione unaRegione,String unAnnoElezione)
	{
		persona=unaPersona;
		regione=unaRegione;
		annoElezione=unAnnoElezione;
	}
	
	public Persona getPersona() {
		return persona;
	}
	public Regione getRegione() {
		return regione;
	}
	public String getAnnoElezione() {
		return annoElezione;
	}
}

public class AggiungiPersonaGiuntaFrame extends JFrame 
{
	private JComboBox personaBox;
	private JLabel personaLbl=new JLabel("Persona:");
	private JPanel personaPnl=new JPanel();
	private JButton personaInfoBtn=new JButton("Info");
	private JComboBox regioneBox;
	private JLabel regioneLbl=new JLabel("Regione:");
	private JButton infoRegioneBtn=new JButton("Info");
	private JPanel regionePnl=new JPanel();
	private JLabel elezioneLbl=new JLabel("Anno elezione:");
	private JTextField elezioneTxt=new JTextField(4);
	private JPanel elezionePnl=new JPanel();
	private JPanel centroPnl=new JPanel();
	private JPanel sudPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	private AggiungiPersonaGiuntaListener listener=new AggiungiPersonaGiuntaListener(this);
	private Modello modello;
	
	public Modello getModello()
	{
		return(modello);
	}
	
	public AggiungiPersonaGiuntaFrame(Modello m)
	{
		super("Elezione di persona a giunte regionali");
		personaBox=new JComboBox(m.getPersone().toArray());		
		regioneBox=new JComboBox(m.getRegioni().toArray());
		personaPnl.add(personaLbl);
		personaPnl.add(personaBox);
		personaPnl.add(personaInfoBtn);
		personaInfoBtn.addActionListener(listener);
		personaInfoBtn.setActionCommand(AggiungiPersonaGiuntaListener.INFOPERSONA);
		regionePnl.add(regioneLbl);
		regionePnl.add(regioneBox);
		regionePnl.add(infoRegioneBtn);		
		infoRegioneBtn.addActionListener(listener);
		infoRegioneBtn.setActionCommand(AggiungiPersonaGiuntaListener.INFOREGIONE);		
		elezionePnl.add(elezioneLbl);
		elezionePnl.add(elezioneTxt);		
		centroPnl.setLayout(new FlowLayout(FlowLayout.LEFT));
		centroPnl.add(personaPnl);
		centroPnl.add(regionePnl);
		centroPnl.add(elezionePnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(listener);
		okBtn.setActionCommand(AggiungiPersonaGiuntaListener.ELEGGIGIUNTA);
		//DA COMPLETARE A CURA DEGLI STUDENTI
		modello=m;
	}
	
	public InfoAggiungiPersonaGiunta getInformazioni()
	{
		InfoAggiungiPersonaGiunta info;
		info=new InfoAggiungiPersonaGiunta(
				(Persona)personaBox.getSelectedItem(), 
				(Regione)regioneBox.getSelectedItem(), 
				elezioneTxt.getText());
		return(info);
	}
	
	public void reset()
	{
		personaBox.setSelectedIndex(0);
		regioneBox.setSelectedIndex(0);
		elezioneTxt.setText("");
	}
}
