package giunte;

public class TipoLinkGiunta 
{
	private final Regione laRegione;
	private final Persona laPersona;
	private final int annoElezione;
	public TipoLinkGiunta(Regione x, Persona y, int a)
	throws EccezionePrecondizioni {
		if (x == null || y == null || a <= 0) // CONTROLLO PRECONDIZIONI
			throw new EccezionePrecondizioni
			("Gli oggetti devono essere inizializzati\n" +
			"e lanno di elezione deve essere positivo");
		laRegione = x; laPersona = y;
		annoElezione = a;
	}
	public Regione getRegione() { return laRegione; }
	public Persona getPersona() { return laPersona; }
	public int getAnnoElezione() { return annoElezione; }
	
	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkGiunta t = (TipoLinkGiunta)o;
			return t.laPersona == laPersona && t.laRegione == laRegione;
		}
		else return false;
	}
	public int hashCode() {
		return laPersona.hashCode() + laRegione.hashCode();
	}
}