package gui;

import giunte.*;

import java.util.*;



public final class Modello 
{
	private Map<String,Partito> partiti = new HashMap<String,Partito>();
	private Map<String,Regione> regioni= new HashMap<String,Regione>();
	private Map<Nominativo,Persona> persone= new HashMap<Nominativo,Persona>();

	public Collection<Partito> getPartiti()
	{
		Collection<Partito> unMod=Collections.unmodifiableCollection(partiti.values());
		return(unMod);
	}

	public Collection<Persona> getPersone()
	{
		Collection<Persona> unMod=Collections.unmodifiableCollection(persone.values());
		return(unMod);	
	}
	
	public Collection<Regione> getRegioni()
	{
		Collection<Regione> unMod=Collections.unmodifiableCollection(regioni.values());
		return(unMod);	
	}
	
	public void addPartito(Partito partito) throws EccezionePrecondizioni
	{
		boolean esiste=partiti.containsKey(partito.getNome());
		if(!esiste)
			partiti.put(partito.getNome(), partito);
		else
			throw(new EccezionePrecondizioni("Il partito "+partito+" esiste gi"));
	}

	public void addRegione(Regione regione) throws EccezionePrecondizioni
	{
		boolean esiste=regioni.containsKey(regione.getNome());
		if(!esiste)
			regioni.put(regione.getNome(), regione);
		else
			throw(new EccezionePrecondizioni("La regione "+regione+" esiste gi"));

	}	

	public void addPersona(Persona persona) throws EccezionePrecondizioni
	{
		Nominativo nome=new Nominativo(persona.getNome(),persona.getCognome());
		boolean esiste=persone.containsKey(nome);
		if(!esiste)
			persone.put(nome, persona);
		if (esiste)
			throw(new EccezionePrecondizioni("Esiste gi una persona con lo stesso nome e cognome"));
	}	
	
	public void addPersonaPartito(Persona persona,Partito partito,int annoIscrizione)
		throws EccezionePrecondizioni
	{
		Nominativo nomin=new Nominativo(persona.getNome(),persona.getCognome());
		if (persone.containsKey(nomin) && partiti.containsKey(partito.getNome()))
		{
			TipoLinkIscritto link=new TipoLinkIscritto(partito, persona, annoIscrizione);
			persona.inserisciLinkIscritto(link);
		}
		else
			throw(new EccezionePrecondizioni("La persona "+persona+ "o il partito "+partito+" non esiste"));
	}
	
	public void addPersonaGiunta(Persona persona,Regione regione,int annoElezione)
		throws EccezionePrecondizioni
	{
		Nominativo nomin=new Nominativo(persona.getNome(),persona.getCognome());
		if (persone.containsKey(nomin) && regioni.containsKey(regione.getNome()))
		{
			TipoLinkGiunta link=new TipoLinkGiunta(regione,persona,annoElezione);
			if (regione!=null)
			regione.inserisciInGiunta(link);
		}
		else
			throw(new EccezionePrecondizioni("La persona "+persona+ "o la regione "+regione+" non esiste"));
	}
}

