package gui;

import giunte.Persona;

import java.awt.BorderLayout;
import java.awt.Font;

import javax.swing.*;



public class InfoPersonaFrame extends JFrame
{
	private JLabel dataNascitaIntestLbl=new JLabel("Anno nascita:");
	private JLabel dataNascitaLbl=new JLabel();
	private JPanel dataNascitaPnl=new JPanel();
	private JLabel partitoIscrIntestLbl=new JLabel("Partito politico Iscritto:");
	private JLabel partitoIscrLbl=new JLabel();
	private JPanel partitoIscrPnl=new JPanel();
	
	public InfoPersonaFrame(Persona p)
	{
		super("Informazioni per la persona "+p);
		Font grassetto=dataNascitaIntestLbl.getFont().deriveFont(Font.BOLD); 
		String nomePartito="(Non iscritto)";
		if (p.getLinkIscritto()!=null)
			nomePartito=p.getLinkIscritto().getPartito().getNome();
		String dataNascita=p.getGiornoNascita()
		+"/"+p.getMeseNascita()
		+"/"+p.getAnnoNascita();

		dataNascitaIntestLbl.setFont(grassetto);
		dataNascitaPnl.add(dataNascitaIntestLbl);
		dataNascitaLbl.setText(dataNascita);
		dataNascitaPnl.add(dataNascitaLbl);

		partitoIscrIntestLbl.setFont(grassetto);
		partitoIscrLbl.setText(nomePartito);
		partitoIscrPnl.add(partitoIscrIntestLbl);
		partitoIscrPnl.add(partitoIscrLbl);

		getContentPane().add(dataNascitaPnl,BorderLayout.CENTER);
		getContentPane().add(partitoIscrPnl,BorderLayout.SOUTH);
		pack();
		setVisible(true);
	}
	
}
