package gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.*;

class InfoAggiungiPersona
{
	private String nome;
	private String cognome;
	private String ggNascita;
	private String mmNascita;
	private String aaNascita;
	
	public InfoAggiungiPersona(String unNome,String unCognome,String gg,String mm,String aa)
	{
		nome=unNome;
		cognome=unCognome;
		ggNascita=gg;
		mmNascita=mm;
		aaNascita=aa;
	}
	
	public String getNome() {
		return nome;
	}
	public String getCognome() {
		return cognome;
	}
	public String getGGNascita() {
		return ggNascita;
	}
	public String getMMNascita() {
		return mmNascita;
	}
	public String getAANascita() {
		return aaNascita;
	}
}

public class AggiungiPersonaFrame extends JFrame 
{
	private JLabel nomeLbl=new JLabel("Nome:");
	private JTextField nomeTxt=new JTextField(20);
	private JPanel nomePnl=new JPanel();
	private JLabel cognomeLbl=new JLabel("Cognome:");
	private JTextField cognomeTxt=new JTextField(20);
	private JPanel cognomePnl=new JPanel();
	private JLabel nascitaLbl=new JLabel("Data di nascita:");
	private JTextField ggNascitaTxt=new JTextField(2);
	private JLabel barra1Lbl=new JLabel("/");
	private JLabel barra2Lbl=new JLabel("/");
	private JTextField mmNascitaTxt=new JTextField(2);
	private JTextField aaNascitaTxt=new JTextField(2);
	private JPanel dataNascitaPnl=new JPanel();
	private JPanel centroPnl=new JPanel();
	private JPanel sudPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	private AggiungiPersonaListener listener=new AggiungiPersonaListener(this);
	private Modello modello;
	
	public Modello getModello()
	{
		return(modello);
	}
	
	public AggiungiPersonaFrame(Modello m) 
	{
		super("Aggiungi Persona");
		nomePnl.add(nomeLbl);
		nomePnl.add(nomeTxt);
		cognomePnl.add(cognomeLbl);
		cognomePnl.add(cognomeTxt);
		dataNascitaPnl.add(nascitaLbl);
		dataNascitaPnl.add(ggNascitaTxt);
		dataNascitaPnl.add(barra1Lbl);
		dataNascitaPnl.add(mmNascitaTxt);
		dataNascitaPnl.add(barra2Lbl);
		dataNascitaPnl.add(aaNascitaTxt);
		centroPnl.setLayout(new FlowLayout(FlowLayout.LEFT));
		centroPnl.add(nomePnl);
		centroPnl.add(cognomePnl);
		centroPnl.add(dataNascitaPnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(listener);
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);		
		this.setSize(350,220);
		this.setVisible(true);
		this.setResizable(false);
		modello=m;
	}

	public InfoAggiungiPersona getInformazioni()
	{
		InfoAggiungiPersona info=
			new InfoAggiungiPersona(nomeTxt.getText(), 
										cognomeTxt.getText(), 
										ggNascitaTxt.getText(), 
										mmNascitaTxt.getText(), 
										aaNascitaTxt.getText());
		return(info);
	}

	public void reset()
	{
		nomeTxt.setText("");
		cognomeTxt.setText("");
		ggNascitaTxt.setText("");
		mmNascitaTxt.setText("");
		aaNascitaTxt.setText("");
	}


}
