package gui;

import giunte.EccezionePrecondizioni;
import giunte.Partito;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;



public class AggiungiPartitoListener implements ActionListener 
{
	private AggiungiPartitoFrame frame;
	
	public AggiungiPartitoListener(AggiungiPartitoFrame unFrame)
	{
		this.frame=unFrame;
	}
	
	
	public void actionPerformed(ActionEvent ae) 
	{
		try {
			InfoAggiungiPartito info=frame.getInformazioni();
			int annoFondazione;
			annoFondazione = Integer.parseInt(info.getAnnoFondazione());
			Partito p=new Partito(info.getNome(),annoFondazione);
			frame.getModello().addPartito(p);
			frame.reset();
			Utility.
				messaggioAvviso(frame, "Il partito "+p+"  stato aggiunto correttamente");
		} 
		catch (NumberFormatException e) {
			Utility.messaggioErrore(frame, "Il formato dell'anno fondazione  errato");
		}
		catch (EccezionePrecondizioni e) {
			Utility.messaggioErrore(frame, e.getMessage());
		}
	}

}
