package gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.*;

class InfoAggiungiPartito
{
	private String nome;
	private String annoFondazione;
	
	public InfoAggiungiPartito(String unNome,String aa)
	{
		nome=unNome;
		annoFondazione=aa;
	}
	
	public String getNome() {
		return nome;
	}

	public String getAnnoFondazione() {
		return annoFondazione;
	}
}

public class AggiungiPartitoFrame extends JFrame 
{
	private JLabel nomeLbl=new JLabel("Nome:");
	private JTextField nomeTxt=new JTextField(20);
	private JPanel nomePnl=new JPanel();
	private JLabel fondazioneLbl=new JLabel("Anno Fondazione:");
	private JTextField fondazioneTxt=new JTextField(4);
	private JPanel fondazionePnl=new JPanel();
	private JPanel centroPnl=new JPanel();
	private JPanel sudPnl=new JPanel();
	private JButton okBtn=new JButton("OK");
	private AggiungiPartitoListener listener=new AggiungiPartitoListener(this);
	private Modello modello;
	
	public Modello getModello()
	{
		return(modello);
	}
	
	public AggiungiPartitoFrame(Modello m) 
	{
		super("Aggiungi Partito");
		nomePnl.add(nomeLbl);
		nomePnl.add(nomeTxt);
		fondazionePnl.add(fondazioneLbl);
		fondazionePnl.add(fondazioneTxt);
		centroPnl.setLayout(new FlowLayout(FlowLayout.LEFT));
		centroPnl.add(nomePnl);
		centroPnl.add(fondazionePnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(listener);
		this.getContentPane().add(centroPnl,BorderLayout.CENTER);
		this.getContentPane().add(sudPnl,BorderLayout.SOUTH);		
		this.setSize(350,220);
		this.setVisible(true);
		this.setResizable(false);
		modello=m;
	}

	public InfoAggiungiPartito getInformazioni()
	{
		InfoAggiungiPartito info=null;
		info=new InfoAggiungiPartito(nomeTxt.getText(),fondazioneTxt.getText());
		return(info);
	}

	public void reset()
	{
		nomeTxt.setText("");
		fondazioneTxt.setText("");
	}
}
