package giunte;

import java.util.*;

public class Regione {
	private final String nome;
	private HashSet<TipoLinkGiunta> giunta;

	public Regione(String x) {
		nome = x;
		giunta = new HashSet<TipoLinkGiunta>();
	}
	
	public String getNome() { return nome; }
	
	public void inserisciInGiunta(TipoLinkGiunta g) {
		if (g != null && g.getRegione() == this)
			giunta.add(g);
	}
	
	public void eliminaInGiunta(TipoLinkGiunta g) {
		if (g != null && g.getRegione() == this)
			giunta.remove(g);
	}
	
	public Set<TipoLinkGiunta> getGiunta() {
		return (Set<TipoLinkGiunta>)giunta.clone(); 
	}
	
	public String toString()
	{
		return(nome);
	}
}

